/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.InPlanPtnStoreActivity;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Tuple;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeShiftStabilityAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(TimeShiftStabilityAnalyzer.class);

    public static Changes calculateShift(Superplan superplan, Params params) {
        LOG.info("Shifting superplan to new fixation date {}, i.e. by {} ms.", (Object)new Date(params.newFixationDate), (Object)(superplan.getFixationDate() - params.newFixationDate));
        CrModel crModelBefore = new CrModel(superplan.getFixationDate(), 604800000L);
        CrModel crModelAfter = new CrModel(params.newFixationDate, 604800000L);
        Changes changes = new Changes(params.newFixationDate, params.gorReleaseHorizon, params.crRefillFactor, params.seed);
        HashSet<String> takenCrIds = Sets.newHashSet();
        LOG.info("Scanning ESAs...");
        for (ExternalStoreActivity esa : superplan.getExternalStoreActivities(StoreType.EXTERNAL)) {
            TimeShiftStabilityAnalyzer.processEsa(esa, changes, params);
        }
        LOG.info("Scanning SRs...");
        for (SupplyRequest sr : superplan.getSupplyRequests()) {
            TimeShiftStabilityAnalyzer.processSr(sr, changes, params);
        }
        LOG.info("Scanning CRs...");
        crModelBefore.processPoorRichMatprods(superplan.getCustomerRequests());
        crModelAfter.processPoorRichMatprods(superplan.getCustomerRequests());
        for (CustomerRequest cr : superplan.getCustomerRequests()) {
            crModelBefore.countCr(cr);
            if (!TimeShiftStabilityAnalyzer.processCr(cr, changes, params, superplan)) continue;
            crModelAfter.countCr(cr);
            takenCrIds.add(cr.getId());
        }
        LOG.info("Scanning GORs.");
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            TimeShiftStabilityAnalyzer.processGor(gor, changes, params);
        }
        TimeShiftStabilityAnalyzer.generateCrs(changes, takenCrIds, crModelBefore, crModelAfter, params);
        return changes;
    }

    private static void generateCrs(Changes changes, Set<String> takenCrIds, CrModel crModelBefore, CrModel crModelAfter, Params params) {
        if (params.crRefillFactor < 1.0E-7) {
            return;
        }
        Random rng = new Random(params.seed);
        HashMap<Material, Integer> crIdNumbers = Maps.newHashMap();
        for (Map.Entry<Material, Map<Integer, List<Double>>> entry : crModelBefore.richMatQties.rowMap().entrySet()) {
            long binEnd;
            long binStart;
            Material m3 = entry.getKey();
            Map<Integer, List<Double>> bins = entry.getValue();
            int excessCnt = 0;
            int binsCnt = 0;
            for (Map.Entry<Integer, List<Double>> binEntry : bins.entrySet()) {
                int afterCount;
                int bin = binEntry.getKey();
                binStart = Math.max(crModelAfter.binStart + crModelAfter.binLength * (long)bin, changes.newFixationDate);
                if (binStart >= (binEnd = crModelAfter.binStart + crModelAfter.binLength * (long)(bin + 1))) continue;
                ++binsCnt;
                int beforeCount = binEntry.getValue().size();
                if (beforeCount >= (afterCount = Collections3.nullToEmpty(crModelAfter.richMatQties.get(m3, binEntry.getKey())).size())) continue;
                excessCnt += afterCount - beforeCount;
            }
            for (Map.Entry<Integer, List<Double>> binEntry : bins.entrySet()) {
                Integer bin = binEntry.getKey();
                binStart = Math.max(crModelAfter.binStart + crModelAfter.binLength * (long)bin.intValue(), changes.newFixationDate);
                if (binStart >= (binEnd = crModelAfter.binStart + crModelAfter.binLength * (long)(bin + 1))) continue;
                float floatExcess = (float)excessCnt / (float)binsCnt;
                int excess = Math.round(floatExcess);
                if ((float)excess < floatExcess) {
                    ++excess;
                }
                List<Double> before = binEntry.getValue();
                int beforeCount = before.size();
                double beforeQty = before.stream().mapToDouble(value -> value).sum();
                double beforeMeanQty = beforeQty / (double)beforeCount;
                double beforeStd = Math.sqrt(before.stream().mapToDouble(value -> Math.pow(value - beforeMeanQty, 2.0)).sum() / (double)beforeCount);
                List<Double> afterQties = crModelAfter.richMatQties.get(m3, bin);
                if (afterQties == null) {
                    afterQties = Collections.emptyList();
                }
                int afterCount = afterQties.size();
                double afterQty = afterQties.stream().mapToDouble(value -> value).sum();
                int toFillNum = (int)((double)(beforeCount - afterCount) * Math.sqrt(params.crRefillFactor));
                if (toFillNum >= excess) {
                    toFillNum -= excess;
                    excessCnt -= excess;
                } else {
                    excessCnt -= toFillNum;
                    toFillNum = 0;
                }
                double toFillQty = (beforeQty - afterQty) * Math.sqrt(params.crRefillFactor);
                while (toFillNum > 0) {
                    double qty;
                    int n;
                    String id;
                    do {
                        n = crIdNumbers.compute(m3, (material, cnt) -> cnt == null ? 1 : cnt + 1);
                    } while (takenCrIds.contains(id = "generatedR-" + m3.getId() + "-" + n));
                    while ((qty = rng.nextGaussian() * beforeStd + beforeMeanQty) <= 1.0E-7) {
                    }
                    long time = Math.floorMod(rng.nextLong(), binEnd - binStart) + binStart;
                    CustomerRequest cr = new CustomerRequest(id, m3, time, qty, 5);
                    changes.addCrToAdd(cr);
                    --toFillNum;
                }
                --binsCnt;
            }
        }
        ArrayList<Material> poorMats = Lists.newArrayList(crModelBefore.poorMatsQties.keySet());
        int excessCnt = 0;
        int binsCnt = 0;
        for (Map.Entry<Integer, Integer> binEntry : crModelBefore.poorMatsBins.entrySet()) {
            int afterCount;
            long binEnd;
            int bin = binEntry.getKey();
            long binStart = Math.max(crModelAfter.binStart + crModelAfter.binLength * (long)bin, changes.newFixationDate);
            if (binStart >= (binEnd = crModelAfter.binStart + crModelAfter.binLength * (long)(bin + 1))) continue;
            ++binsCnt;
            int beforeCount = binEntry.getValue();
            if (beforeCount >= (afterCount = crModelAfter.poorMatsBins.get(bin) == null ? 0 : crModelAfter.poorMatsBins.get(bin))) continue;
            excessCnt += afterCount - beforeCount;
        }
        for (Map.Entry<Integer, Integer> entry : crModelBefore.poorMatsBins.entrySet()) {
            int toFillNum;
            long binEnd;
            long binStart;
            Integer bin = entry.getKey();
            Integer beforeCount = entry.getValue();
            Integer afterCount = crModelAfter.poorMatsBins.get(bin);
            if (afterCount == null) {
                afterCount = 0;
            }
            if ((binStart = Math.max(crModelAfter.binStart + crModelAfter.binLength * (long)bin.intValue(), changes.newFixationDate)) >= (binEnd = crModelAfter.binStart + crModelAfter.binLength * (long)(bin + 1))) continue;
            float floatExcess = (float)excessCnt / (float)binsCnt;
            int excess = Math.round(floatExcess);
            if ((float)excess < floatExcess) {
                ++excess;
            }
            if ((toFillNum = (int)((double)(beforeCount - afterCount) * params.crRefillFactor)) >= excess) {
                toFillNum -= excess;
                excessCnt -= excess;
            } else if (toFillNum > 0) {
                excessCnt -= toFillNum;
                toFillNum = 0;
            }
            while (toFillNum > 0) {
                double qty;
                int n;
                String id;
                Material m4 = (Material)poorMats.get(rng.nextInt(poorMats.size()));
                do {
                    n = crIdNumbers.compute(m4, (material, cnt) -> cnt == null ? 1 : cnt + 1);
                } while (takenCrIds.contains(id = "generatedP-" + m4.getId() + "-" + n));
                List<Double> before = crModelBefore.poorMatsQties.get(m4);
                double beforeQty = before.stream().mapToDouble(value -> value).sum();
                double beforeMeanQty = beforeQty / (double)before.size();
                double beforeStd = Math.sqrt(before.stream().mapToDouble(value -> Math.pow(value - beforeMeanQty, 2.0)).sum() / (double)before.size());
                if (before.size() < 3) {
                    beforeStd = beforeMeanQty * 0.1;
                }
                while ((qty = rng.nextGaussian() * beforeStd + beforeMeanQty) <= 1.0E-7) {
                }
                long time = Math.floorMod(rng.nextLong(), binEnd - binStart) + binStart;
                CustomerRequest cr = new CustomerRequest(id, m4, time, qty, 5);
                changes.addCrToAdd(cr);
                --toFillNum;
            }
            --binsCnt;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void applyShift(Superplan superplan, Changes changes, boolean mergeInitStock) {
        int cnt;
        LOG.info("Setting stock init date...");
        superplan.setStockInitDate(superplan.getStockInitDate() + (changes.newFixationDate - superplan.getFixationDate()));
        LOG.info("Setting fixation date...");
        superplan.setFixationDate(changes.newFixationDate);
        LOG.info("Inserting init stock ESAs...");
        if (mergeInitStock) {
            void var5_5;
            HashMap<Material, Tuple> initStock = Maps.newHashMap();
            boolean bl = false;
            for (Map.Entry<Material, Tuple<Double, String>> entry : changes.newInitStock.entries()) {
                if (!(Math.abs(entry.getValue().getFirst()) > 1.0E-7)) continue;
                initStock.merge(entry.getKey(), Tuple.create(entry.getValue().getFirst(), entry.getValue().getSecond()), (a, b) -> Tuple.create((Double)a.getFirst() + (Double)b.getFirst(), String.join((CharSequence)"|", (CharSequence)a.getSecond(), (CharSequence)b.getSecond())));
                ++var5_5;
            }
            cnt = 0;
            for (Map.Entry<Material, Tuple<Double, String>> entry : initStock.entrySet()) {
                if (!(Math.abs(entry.getValue().getFirst()) > 1.0E-7)) continue;
                if (entry.getValue().getFirst() < 0.0) {
                    LOG.warn("Init stock of material {} results to negative amount: {} ({})", entry.getKey(), entry.getValue().getFirst(), entry.getValue().getSecond());
                }
                ExternalStoreActivity newEsa = new ExternalStoreActivity(superplan.getStockInitDate(), entry.getKey(), entry.getValue().getFirst(), entry.getValue().getSecond());
                LOG.debug("Creating new ESA: {}; description: {}", (Object)newEsa, (Object)newEsa.getDescription());
                superplan.getPlan().addActivity(newEsa);
                ++cnt;
            }
            LOG.info("Inserting init stock ESAs finished: {} ESAs merged from {} events.", (Object)cnt, (Object)((int)var5_5));
        } else {
            cnt = 0;
            for (Map.Entry<Material, Tuple<Double, String>> entry : changes.newInitStock.entries()) {
                if (!(Math.abs(entry.getValue().getFirst()) > 1.0E-7)) continue;
                ExternalStoreActivity newEsa = new ExternalStoreActivity(superplan.getStockInitDate(), entry.getKey(), entry.getValue().getFirst(), entry.getValue().getSecond());
                LOG.debug("Creating new ESA: {}; description: {}", (Object)newEsa, (Object)newEsa.getDescription());
                superplan.getPlan().addActivity(newEsa);
                ++cnt;
            }
            LOG.info("Inserting init stock ESAs finished: {} ESAs.", (Object)cnt);
        }
        LOG.info("Removing ESAs...");
        cnt = 0;
        for (ExternalStoreActivity externalStoreActivity : changes.esasToRemove) {
            LOG.debug("Removing ESA: {}", (Object)externalStoreActivity);
            superplan.getPlan().removeActivity(externalStoreActivity);
            ++cnt;
        }
        LOG.info("Removing ESAs finished: {} ESAs.", (Object)cnt);
        LOG.info("Removing SRs...");
        cnt = 0;
        for (SupplyRequest supplyRequest : changes.srsToRemove) {
            LOG.debug("Removing SR: {}", (Object)supplyRequest);
            superplan.removeSupplyRequest(supplyRequest);
            ++cnt;
        }
        LOG.info("Removing SRs finished: {} SRs.", (Object)cnt);
        LOG.info("Removing CRs...");
        cnt = 0;
        for (CustomerRequest customerRequest : changes.crsToRemove) {
            LOG.debug("Removing CR: {}", (Object)customerRequest);
            superplan.removeCustomerRequest(customerRequest);
            ++cnt;
        }
        LOG.info("Removing CRs finished: {} CRs.", (Object)cnt);
        LOG.info("Removing related activities from PTNs...");
        cnt = 0;
        for (ProductionTreeNode productionTreeNode : changes.ptnsToRemoveActivities) {
            LOG.debug("Removing activities of {}.", (Object)productionTreeNode);
            cnt += ProductionTreeAlgorithms.removeRelatedActivities(productionTreeNode).size();
        }
        LOG.info("Removing related activities from PTNs finished: {} activities.", (Object)cnt);
        LOG.info("Setting SR states...");
        cnt = 0;
        for (Map.Entry entry : changes.srStates.entrySet()) {
            LOG.debug("Setting state of SR {} to {}.", entry.getKey(), (Object)((SupplyRequest.State)((Object)entry.getValue())).name());
            ((SupplyRequest)entry.getKey()).setState((SupplyRequest.State)((Object)entry.getValue()));
            ++cnt;
        }
        LOG.info("Setting SR states finished: {} GORs.", (Object)cnt);
        LOG.info("Setting GOR states...");
        cnt = 0;
        for (Map.Entry entry : changes.gorStates.entrySet()) {
            LOG.debug("Setting state of GOR {} to {}.", entry.getKey(), (Object)((GeneralizedOrderRequest.State)((Object)entry.getValue())).name());
            ((GeneralizedOrderRequest)entry.getKey()).setState((GeneralizedOrderRequest.State)((Object)entry.getValue()));
            ++cnt;
        }
        LOG.info("Setting GOR states finished: {} GORs.", (Object)cnt);
        LOG.info("Setting out-of-plan-mat...");
        cnt = 0;
        for (Map.Entry entry : changes.outOfPlanMats.entrySet()) {
            LOG.debug("Setting outOfPlanMat of GAR {} of GOR {} to {}.", entry.getKey(), ((GeneralizedActionRequest)entry.getKey()).getParent(), entry.getValue());
            ((GeneralizedActionRequest)entry.getKey()).setOutOfPlanMat((Double)entry.getValue());
            ++cnt;
        }
        LOG.info("Setting out-of-plan-mat finished: {} GARs.", (Object)cnt);
        LOG.info("Setting out-of-plan-qty...");
        cnt = 0;
        for (Map.Entry entry : changes.outOfPlanQties.entrySet()) {
            LOG.debug("Setting outOfPlanQty of GAR {} of GOR {} to {}.", entry.getKey(), ((GeneralizedActionRequest)entry.getKey()).getParent(), entry.getValue());
            ((GeneralizedActionRequest)entry.getKey()).setOutOfPlanQty((Double)entry.getValue());
            ++cnt;
        }
        LOG.info("Setting out-of-plan-qty finished: {} GARs.", (Object)cnt);
        LOG.info("Removing GORs...");
        cnt = 0;
        for (GeneralizedOrderRequest generalizedOrderRequest : changes.gorsToRemove) {
            LOG.debug("Removing GOR {}.", (Object)generalizedOrderRequest);
            superplan.removeGor(generalizedOrderRequest);
            ++cnt;
        }
        LOG.info("Removing GORs finished: {} GORs.", (Object)cnt);
        LOG.info("Adding CRs...");
        cnt = 0;
        for (CustomerRequest customerRequest : changes.crsToAdd) {
            LOG.debug("Adding CR: {}", (Object)customerRequest);
            superplan.addCustomerRequest(customerRequest);
            ++cnt;
        }
        LOG.info("Adding CRs finished: {} CRs.", (Object)cnt);
    }

    private static void processEsa(ExternalStoreActivity esa, Changes changes, Params params) {
        if (esa.getTime() >= params.newFixationDate) {
            return;
        }
        Material mat = esa.getMaterial();
        changes.addToInitStock(mat, Tuple.create(esa.getQty(), "ESA before fix: " + esa));
        changes.addEsaToRemove(esa);
    }

    private static void processSr(SupplyRequest sr, Changes changes, Params params) {
        if (sr.getState().equals((Object)SupplyRequest.State.CONFIRMED)) {
            return;
        }
        if (sr.getTime() >= params.newFixationDate && sr.getTime() < sr.getMaterial().getMaterialHorizon()) {
            changes.addSrStateChange(sr, SupplyRequest.State.CONFIRMED);
            return;
        }
        if (sr.getTime() < params.newFixationDate) {
            changes.addToInitStock(sr.getMaterial(), Tuple.create(sr.getQty(), "SR before fix: " + sr));
        }
        changes.addSrToRemove(sr);
    }

    private static boolean processCr(CustomerRequest cr, Changes changes, Params params, Superplan superplan) {
        StoreDependencyGraph sdg = superplan.getSDGraph();
        if (!sdg.getNode(cr).isComplete() || sdg.getNode(cr).getMatprodPreparedTime() >= params.newFixationDate) {
            return true;
        }
        changes.addCrToRemove(cr);
        changes.addToInitStock(cr.getMaterial(), Tuple.create(-cr.getQty(), "CR before fix and complete: " + cr));
        return false;
    }

    private static void processGor(GeneralizedOrderRequest gor, Changes ds, Params params) {
        if (gor.getStartDate() >= params.newFixationDate + params.gorReleaseHorizon) {
            if (gor.getState() == GeneralizedOrderRequest.State.PROPOSED) {
                ds.addGorToRemove(gor);
            } else {
                for (GeneralizedActionRequest gar : gor.getGars()) {
                    TimeShiftStabilityAnalyzer.processGar(gar, ds, params);
                }
            }
            return;
        }
        if (gor.getStartDate() >= params.newFixationDate && gor.getStartDate() < params.newFixationDate + params.gorReleaseHorizon) {
            ds.addGorStateChange(gor, GeneralizedOrderRequest.State.PLANNING);
            for (GeneralizedActionRequest gar : gor.getGars()) {
                TimeShiftStabilityAnalyzer.processGar(gar, ds, params);
            }
            return;
        }
        if (gor.getEndDate() >= params.newFixationDate) {
            ds.addGorStateChange(gor, GeneralizedOrderRequest.State.RUNNING);
            for (GeneralizedActionRequest gar : gor.getGars()) {
                TimeShiftStabilityAnalyzer.processGar(gar, ds, params);
            }
            return;
        }
        if (gor.getEndDate() < params.newFixationDate) {
            for (GeneralizedActionRequest gar : gor.getGars()) {
                TimeShiftStabilityAnalyzer.processGar(gar, ds, params);
            }
            ds.addGorToRemove(gor);
            return;
        }
        throw new IllegalStateException();
    }

    private static void processGar(GeneralizedActionRequest gar, Changes ds, Params params) {
        if (gar.getStartDate() >= params.newFixationDate) {
            ds.toRemoveActivities(gar);
            return;
        }
        if (gar.getEndDate() >= params.newFixationDate) {
            double doneMatQty;
            long totalDuration = 0L;
            long pastDuration = 0L;
            double totalQty = 0.0;
            for (ActionActivity aa : gar.getActivities()) {
                totalQty += aa.getQty();
                totalDuration += aa.getDuration();
                pastDuration += aa.getDurationIn(Long.MIN_VALUE, params.newFixationDate);
            }
            double doneRatio = (double)pastDuration / (double)totalDuration;
            double currentDoneQty = gar.getAction().roundQtyWrtGranularityDown(totalQty * doneRatio);
            double doneQty = gar.getOutOfPlanQty() + currentDoneQty;
            for (MaterialQuantity mq : gar.getAction().getBom().ingredients()) {
                if (!mq.getMaterial().isConsumed()) continue;
                doneMatQty = mq.getQty() * currentDoneQty;
                ds.addToInitStock(mq.getMaterial(), Tuple.create(-doneMatQty, "GAR split in half; GAR: " + gar + "; GOR: " + gar.getParent()));
            }
            for (MaterialQuantity mq : gar.getAction().getProduces()) {
                doneMatQty = mq.getQty() * currentDoneQty;
                ds.addToInitStock(mq.getMaterial(), Tuple.create(doneMatQty, "GAR split in half; GAR: " + gar + "; GOR: " + gar.getParent()));
            }
            ds.addToOutOfPlanMat(gar, doneQty);
            ds.addToOutOfPlanQty(gar, doneQty);
            ds.toRemoveActivities(gar);
            return;
        }
        if (gar.getEndDate() < params.newFixationDate) {
            for (InPlanPtnStoreActivity ipsa : gar.getStoreActivities()) {
                double qty = ipsa.getQty();
                Material material = ipsa.getMaterial();
                ds.addToInitStock(material, Tuple.create(qty, "GAR in past; GAR: " + gar + "; GOR: " + gar.getParent()));
            }
            ds.addToOutOfPlanMat(gar, gar.getRequestedQty());
            ds.addToOutOfPlanQty(gar, gar.getRequestedQty());
            ds.toRemoveActivities(gar);
            return;
        }
        throw new IllegalStateException();
    }

    public static Result comparePlans(Superplan original, Superplan shifted) {
        HashMap<String, Result.CompletenessDifference> crCompletenessDifferences = Maps.newHashMap();
        for (CustomerRequest origCr : original.getCustomerRequests()) {
            long origCompleteDate = original.getSDGraph().getNode(origCr).getMatprodPreparedTime();
            if (origCompleteDate < shifted.getFixationDate()) continue;
            CustomerRequest shiftedCr = shifted.getCustomerRequest(origCr.getId());
            if (shiftedCr == null) {
                LOG.warn("CR {} not present in shifted plan even though its CD {} is after shifted fixation {}.", origCr, origCompleteDate, shifted.getFixationDate());
                continue;
            }
            Preconditions.checkState(origCr.getTime() == shiftedCr.getTime());
            long shiftedCompleteDate = shifted.getSDGraph().getNode(shiftedCr).getMatprodPreparedTime();
            Result.CompletenessDifference cd2 = new Result.CompletenessDifference(origCr.getTime(), origCompleteDate, shiftedCr.getTime(), shiftedCompleteDate);
            crCompletenessDifferences.put(origCr.getId(), cd2);
        }
        return new Result(crCompletenessDifferences);
    }

    public static class Params {
        final long newFixationDate;
        final long gorReleaseHorizon;
        final long seed;
        final double crRefillFactor;

        public Params(long newFixationDate, long gorReleaseHorizon, double crRefillFactor, long seed) {
            this.newFixationDate = newFixationDate;
            this.gorReleaseHorizon = gorReleaseHorizon;
            this.seed = seed;
            this.crRefillFactor = crRefillFactor;
        }

        public Params(long newFixationDate, long gorReleaseHorizon, double crRefillFactor) {
            this(newFixationDate, gorReleaseHorizon, crRefillFactor, System.currentTimeMillis());
        }

        public Params(long newFixationDate, long gorReleaseHorizon) {
            this(newFixationDate, gorReleaseHorizon, 1.0, System.currentTimeMillis());
        }

        public Params(long newFixationDate) {
            this(newFixationDate, 0L, 1.0, System.currentTimeMillis());
        }
    }

    public static class CrModel {
        public static int RICH_MATERIAL_CR_NO = 20;
        Table<Material, Integer, List<Double>> richMatQties = HashBasedTable.create();
        Map<Integer, Integer> poorMatsBins = Maps.newHashMap();
        Map<Material, List<Double>> poorMatsQties = Maps.newHashMap();
        Set<Material> poorMats = Sets.newHashSet();
        long binStart;
        long binLength;

        public CrModel(long binStart, long binLength) {
            this.binStart = binStart;
            this.binLength = binLength;
        }

        public void processPoorRichMatprods(Collection<CustomerRequest> customerRequests) {
            HashMap<Material, Integer> counts = Maps.newHashMap();
            for (CustomerRequest customerRequest : customerRequests) {
                counts.compute(customerRequest.getMaterial(), (material, cnt) -> cnt == null ? 1 : cnt + 1);
            }
            for (Map.Entry entry : counts.entrySet()) {
                if ((Integer)entry.getValue() >= RICH_MATERIAL_CR_NO) continue;
                this.poorMats.add((Material)entry.getKey());
            }
        }

        public void countCr(CustomerRequest cr) {
            int binId = this.getBinId(this.binStart, this.binLength, cr.getTime());
            if (this.poorMats.contains(cr.getMaterial())) {
                this.poorMatsBins.compute(binId, (bin, cnt) -> cnt == null ? 1 : cnt + 1);
                List qties = this.poorMatsQties.computeIfAbsent(cr.getMaterial(), m3 -> Lists.newArrayList());
                qties.add(cr.getQty());
            } else {
                List<Double> cntQties = this.richMatQties.get(cr.getMaterial(), binId);
                if (cntQties == null) {
                    cntQties = Lists.newArrayList();
                    this.richMatQties.put(cr.getMaterial(), binId, cntQties);
                }
                cntQties.add(cr.getQty());
            }
        }

        private int getBinId(long zero, long length, long time) {
            if (time >= zero) {
                return (int)((time - zero) / length);
            }
            return (int)((time - zero) / length) - 1;
        }
    }

    public static class Changes {
        private final long newFixationDate;
        private final long gorReleaseHorizon;
        private final double crRefillFactor;
        private final long seed;
        private final Multimap<Material, Tuple<Double, String>> newInitStock = LinkedListMultimap.create();
        private final List<ExternalStoreActivity> esasToRemove = Lists.newArrayList();
        private final List<SupplyRequest> srsToRemove = Lists.newArrayList();
        private final List<CustomerRequest> crsToRemove = Lists.newArrayList();
        private final List<CustomerRequest> crsToAdd = Lists.newArrayList();
        private final List<GeneralizedOrderRequest> gorsToRemove = Lists.newArrayList();
        private final List<ProductionTreeNode> ptnsToRemoveActivities = Lists.newArrayList();
        private final Map<SupplyRequest, SupplyRequest.State> srStates = Maps.newHashMap();
        private final Map<GeneralizedOrderRequest, GeneralizedOrderRequest.State> gorStates = Maps.newHashMap();
        private final Map<GeneralizedActionRequest, Double> outOfPlanMats = Maps.newHashMap();
        private final Map<GeneralizedActionRequest, Double> outOfPlanQties = Maps.newHashMap();

        private Changes(long newFixationDate, long gorReleaseHorizon, double crRefillFactor, long seed) {
            this.newFixationDate = newFixationDate;
            this.gorReleaseHorizon = gorReleaseHorizon;
            this.crRefillFactor = crRefillFactor;
            this.seed = seed;
        }

        private void addToInitStock(Material mat, Tuple<Double, String> q) {
            this.newInitStock.put(mat, q);
        }

        private void addEsaToRemove(ExternalStoreActivity esa) {
            this.esasToRemove.add(esa);
        }

        private void addSrToRemove(SupplyRequest sr) {
            this.srsToRemove.add(sr);
        }

        private void addCrToRemove(CustomerRequest cr) {
            this.crsToRemove.add(cr);
        }

        private void addCrToAdd(CustomerRequest cr) {
            this.crsToAdd.add(cr);
        }

        private void addGorToRemove(GeneralizedOrderRequest gor) {
            this.gorsToRemove.add(gor);
        }

        private void toRemoveActivities(ProductionTreeNode ptn) {
            this.ptnsToRemoveActivities.add(ptn);
        }

        private void addSrStateChange(SupplyRequest gor, SupplyRequest.State state) {
            this.srStates.put(gor, state);
        }

        private void addGorStateChange(GeneralizedOrderRequest sr, GeneralizedOrderRequest.State state) {
            this.gorStates.put(sr, state);
        }

        private void addToOutOfPlanMat(GeneralizedActionRequest gar, Double q) {
            this.outOfPlanMats.merge(gar, q, (a, b) -> a + b);
        }

        private void addToOutOfPlanQty(GeneralizedActionRequest gar, Double q) {
            this.outOfPlanQties.merge(gar, q, (a, b) -> a + b);
        }

        public long getNewFixationDate() {
            return this.newFixationDate;
        }

        public long getGorReleaseHorizon() {
            return this.gorReleaseHorizon;
        }

        public double getCrRefillFactor() {
            return this.crRefillFactor;
        }

        public long getSeed() {
            return this.seed;
        }

        public int getInitStockChanges() {
            return this.newInitStock.size();
        }

        public int getRemovedEsasNum() {
            return this.esasToRemove.size();
        }

        public int getRemovedSrsNum() {
            return this.srsToRemove.size();
        }

        public int getRemovedCrsNum() {
            return this.crsToRemove.size();
        }

        public int getAddedCrsNum() {
            return this.crsToAdd.size();
        }

        public int getRemovedGorsNum() {
            return this.gorsToRemove.size();
        }

        public int getRemovedActivitiesNodesNum() {
            return this.ptnsToRemoveActivities.size();
        }

        public int getRemovedGorChangedStatesNum() {
            return this.gorStates.size();
        }

        public int getRemovedOopMatNum() {
            return this.outOfPlanMats.size();
        }

        public int getRemovedOopQtyNum() {
            return this.outOfPlanQties.size();
        }

        public String niceToString() {
            return "Init stock items: " + this.newInitStock.size() + "\nESAs to remove: " + this.esasToRemove.size() + "\nSRs to remove: " + this.srsToRemove.size() + "\nCRs to remove: " + this.crsToRemove.size() + "\nGORs to remove: " + this.gorsToRemove.size() + "\nNodes to remove activities from: " + this.ptnsToRemoveActivities.size() + "\nGORs to change state: " + this.gorStates.size() + "\nOut of plan mat settings: " + this.outOfPlanMats.size() + "\nOut of plan qty settings: " + this.outOfPlanQties.size() + "\nCRs to add: " + this.crsToAdd.size() + "\n";
        }
    }

    public static class Result {
        private final ImmutableMap<String, CompletenessDifference> crCompletenessDifferences;

        private Result(Map<String, CompletenessDifference> crCompletenessDifferences) {
            this.crCompletenessDifferences = ImmutableMap.copyOf(crCompletenessDifferences);
        }

        public ImmutableMap<String, CompletenessDifference> getCrCompletenessDifferences() {
            return this.crCompletenessDifferences;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toStringCrCompletenessDifferences(sb);
            return sb.toString();
        }

        private void toStringCrCompletenessDifferences(StringBuilder sb) {
            ArrayList<Map.Entry> diffs = Lists.newArrayList(this.crCompletenessDifferences.entrySet());
            diffs.sort(Comparators.getJointComparator(Lists.newArrayList(Comparator.comparingLong(o -> ((CompletenessDifference)o.getValue()).getCompletedDateDifference()), Comparator.comparingLong(o -> ((CompletenessDifference)o.getValue()).getOrigDueDate()), Comparator.comparing(Map.Entry::getKey))));
            String crIdLabel = "CR id";
            String origCdLabel = "orig completed";
            String shiftedCdLabel = "shifted completed";
            String differenceLabel = "orig - shifted";
            String columnSpace = " ".repeat(2);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            int maxIdLength = crIdLabel.length();
            int maxOrigCdLength = origCdLabel.length();
            int maxShiftedCdLength = shiftedCdLabel.length();
            int maxDifferenceLength = differenceLabel.length();
            for (Map.Entry entry : diffs) {
                maxIdLength = Math.max(maxIdLength, ((String)entry.getKey()).length());
                maxOrigCdLength = Math.max(maxOrigCdLength, df.format(new Date(((CompletenessDifference)entry.getValue()).getOrigCompletedDate())).length());
                maxShiftedCdLength = Math.max(maxShiftedCdLength, df.format(new Date(((CompletenessDifference)entry.getValue()).getShiftedCompletedDate())).length());
                maxDifferenceLength = Math.max(maxDifferenceLength, Result.msToHuman(((CompletenessDifference)entry.getValue()).getCompletedDateDifference()).length());
            }
            String lineFormat = "%-" + maxIdLength + "s" + columnSpace + "%" + maxOrigCdLength + "s" + columnSpace + "%" + maxShiftedCdLength + "s" + columnSpace + "%" + maxDifferenceLength + "s";
            sb.append("Differences in CR completed times\n");
            sb.append("=".repeat(3 * columnSpace.length() + maxIdLength + maxOrigCdLength + maxShiftedCdLength + maxDifferenceLength)).append("\n");
            sb.append(String.format("%-" + maxIdLength + "s" + columnSpace + "%-" + maxOrigCdLength + "s" + columnSpace + "%-" + maxShiftedCdLength + "s" + columnSpace + "%-" + maxDifferenceLength + "s\n", crIdLabel, origCdLabel, shiftedCdLabel, differenceLabel));
            sb.append("=".repeat(maxIdLength)).append(columnSpace).append("=".repeat(maxOrigCdLength)).append(columnSpace).append("=".repeat(maxShiftedCdLength)).append(columnSpace).append("=".repeat(maxDifferenceLength)).append("\n");
            for (Map.Entry entry : diffs) {
                sb.append(String.format(lineFormat, entry.getKey(), df.format(new Date(((CompletenessDifference)entry.getValue()).getOrigCompletedDate())), df.format(new Date(((CompletenessDifference)entry.getValue()).getShiftedCompletedDate())), Result.msToHuman(((CompletenessDifference)entry.getValue()).getCompletedDateDifference())));
                sb.append("\n");
            }
        }

        private static String msToHuman(long time) {
            String sign = " ";
            if (time > 0L) {
                sign = "+";
            } else if (time < 0L) {
                sign = "-";
            }
            time = Math.abs(time);
            long mils = time % 1000L;
            long secs = (time /= 1000L) % 60L;
            long mins = (time /= 60L) % 60L;
            long hrs = (time /= 60L) % 24L;
            long days = time /= 24L;
            return String.format(sign + "%dd %02d:%02d:%02d.%03d", days, hrs, mins, secs, mils);
        }

        public static class CompletenessDifference {
            private final long origDueDate;
            private final long origCompletedDate;
            private final long shiftedDueDate;
            private final long shiftedCompletedDate;

            private CompletenessDifference(long origDueDate, long origCompletedDate, long shiftedDueDate, long shiftedCompletedDate) {
                this.origDueDate = origDueDate;
                this.origCompletedDate = origCompletedDate;
                this.shiftedDueDate = shiftedDueDate;
                this.shiftedCompletedDate = shiftedCompletedDate;
            }

            public long getOrigDueDate() {
                return this.origDueDate;
            }

            public long getOrigCompletedDate() {
                return this.origCompletedDate;
            }

            public long getShiftedDueDate() {
                return this.shiftedDueDate;
            }

            public long getShiftedCompletedDate() {
                return this.shiftedCompletedDate;
            }

            public long getCompletedDateDifference() {
                return this.origCompletedDate - this.shiftedCompletedDate;
            }
        }
    }
}

